#!/bin/bash
set -eo pipefail


NGINX_GID=${NGINX_GID:-101}
NGINX_UID=${NGINX_UID:-101}

# initializing directory
rm -rf /var/lib/softhsm/tokens
mkdir -p /var/lib/softhsm/tokens

# create hsm token

softhsm2-util --init-token --free --label "softHSM" --so-pin abcabc --pin abcabc  

# create root ca

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --keypairgen --key-type EC:prime256v1 --id 1
openssl req -new -x509 -subj "/CN=root" -sha256 -config \
    /etc/ssl/openssl.cnf -engine pkcs11 -keyform engine -key 1 \
    -extensions v3_ca \
    -out /var/lib/softhsm/root.crt

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --type cert \
  --id 1 \
  --write-object /var/lib/softhsm/root.crt 

# create inter ca

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --keypairgen \
  --key-type EC:prime256v1 \
  --id 2

openssl req -new -subj "/CN=inter" -sha256 -config \
    /etc/ssl/openssl.cnf -engine pkcs11 -keyform engine -key 2 \
    -extensions v3_ca \
    -out /var/lib/softhsm/inter.csr

openssl x509 -req -sha256 -days 10000 -engine pkcs11 -CAkeyform engine -set_serial 1 -extfile /etc/ssl/openssl.cnf \
  -CAkey 1 \
  -extensions v3_ca \
  -CA /var/lib/softhsm/root.crt \
  -in /var/lib/softhsm/inter.csr \
  -out /var/lib/softhsm/inter.crt

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --type cert \
  --id 2 \
  --write-object /var/lib/softhsm/inter.crt

# create leaf cert

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --keypairgen \
  --key-type EC:prime256v1 \
  --id 3

openssl req -new -subj "/CN=leaf" -sha256 -config \
    /etc/ssl/openssl.cnf -engine pkcs11 -keyform engine -key 3 \
    -out /var/lib/softhsm/leaf.csr

openssl x509 -req -sha256 -days 365 -engine pkcs11 -CAkeyform engine -set_serial 1 -extfile /etc/ssl/openssl.cnf \
  -CAkey 2 \
  -extensions v3_server \
  -CA /var/lib/softhsm/inter.crt \
  -in /var/lib/softhsm/leaf.csr \
  -out /var/lib/softhsm/leaf.crt

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --type cert \
  --id 3 \
  --write-object /var/lib/softhsm/leaf.crt 

chown -R $NGINX_GID:$NGINX_UID /var/lib/softhsm
