#!/bin/bash
set -eo pipefail

NGINX_GID=${NGINX_GID:-101}
NGINX_UID=${NGINX_UID:-101}

# initializing directory
rm -rf /var/lib/softhsm/tokens
mkdir -p /var/lib/softhsm/tokens

# generate softhsm

softhsm2-util --init-token --free --label "softHSM" --so-pin abcabc --pin abcabc  

# create leaf.csr

pkcs11-tool --module /usr/lib/x86_64-linux-gnu/softhsm/libsofthsm2.so --pin abcabc --keypairgen --key-type EC:prime256v1 --id 1

openssl req -new -subj "/CN=leaf" -sha256 -config \
    /etc/ssl/openssl.cnf -engine pkcs11 -keyform engine -key 1 \
    -out /var/lib/softhsm/leaf.csr

chown -R $NGINX_GID:$NGINX_UID /var/lib/softhsm

### certbot certonly --csr /var/lib/softhsm/leaf.csr --manual -d leaf.example.com --preferred-challenges dns
