package main

import (
	"crypto/x509"
	"log"

	"github.com/google/go-tpm/legacy/tpm2"
	"github.com/google/go-tpm/tpmutil"
)

func main() {
	rwc := NewTcpReadWriteCloser("127.0.0.1:2321")
	defer rwc.Close()

	vals, _, err := tpm2.GetCapability(rwc, tpm2.CapabilityHandles, 254, uint32(tpm2.HandleTypeNVIndex)<<24)
	if err != nil {
		log.Fatalf("GetCapability failed: %v", err)
	}
	if vals == nil {
		log.Printf("vals nil\n")
		return
	}

	for idx, val := range vals {
		persistentHandle := val.(tpmutil.Handle)
		log.Printf("*** [%d] %x ***\n", idx, persistentHandle)

		nvPub, err := tpm2.NVReadPublic(rwc, persistentHandle)
		if err != nil {
			log.Printf("NVReadPublic failed [%x]: %s\n", persistentHandle, err)
			continue
		}
		log.Printf("NV Pub: %+v\n", nvPub)

		dat, err := tpm2.NVRead(rwc, persistentHandle)
		if err != nil {
			log.Printf("NVRead failed [%x]: %s\n", persistentHandle, err)
			continue
		}

		cert, err := x509.ParseCertificate(dat)
		if err != nil {
			log.Printf("ParseCertificate failed [%x]: %s\n", persistentHandle, err)
			continue
		}

		log.Printf("Cert: issuer=%s subject=%s\n", cert.Issuer.String(), cert.Subject.String())
	}
}
