#!/bin/bash

tpm2 -v | tee vertion.txt
swtpm -v | tee -a vertion.txt
tpm2-abrmd -v | tee -a vertion.txt

mkdir -p pcap swtpm

if test -d swtpm-localca; then
  echo "swtpm-localca already exists"
else
  echo "swtpm-localca does not exist. Creating..."
  mkdir swtpm-localca
  swtpm_setup --tpm2 --tpmstate swtpm --logfile swtpm/setup.log \
    --create-ek-cert --write-ek-cert-files swtpm \
    # --create-platform-cert --create-spk
fi

# swtpm socket --tpmstate dir=swtpm --tpm2 \
#   --server type=unixio,,mode=0777,path=swtpm/swtpm-sock \
#   --ctrl type=unixio,mode=0777,path=swtpm/swtpm-sock.ctrl \
#   --seccomp action="none" --flags not-need-init,startup-clear \
#   --log level=20,file=swtpm/swtpm.log  2>/dev/null &
swtpm socket --tpmstate dir=swtpm --tpm2 \
  --server port=2321,bindaddr=0.0.0.0 \
  --ctrl type=tcp,port=2322,bindaddr=0.0.0.0 \
  --seccomp action="none" --flags not-need-init,startup-clear \
  --log level=20,file=swtpm/swtpm.log  2>/dev/null &
swtpm_pid=$!
sleep 1

dbus-daemon --config-file=/usr/share/dbus-1/system.conf
#tpm2-abrmd --allow-root --tcti=swtpm:path=/swtpm/swtpm/swtpm-sock 2>/dev/null &
tpm2-abrmd --allow-root --tcti=swtpm:port=2321 2>/dev/null &

touch "$TCTI_PCAP_FILE"
dumpcap -i any -w "$TCTI_PCAP_FILE" -f 'portrange 2321-2322' 2>/dev/null &
tail -n 0 -f "$TCTI_PCAP_FILE" | tshark -r - 2>/dev/null -Y tpm

kill $swtpm_pid